/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.frame;

import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.websm.property.WPropertyEditor;
import com.ibm.websm.property.WPropertyReadText;
import java.util.Hashtable;

public class CSPStateText
extends WPropertyReadText {
    public static final int STATE_READY = 1;
    public static final int STATE_NO_POWER = 3;
    public static final int STATE_BOOTING = 5;
    public static final int STATE_INITIALIZING = 6;
    public static final int STATE_RUNNING = 8;
    public static final int STATE_OPEN_FIRMWARE = 9;
    public static final int STATE_ERROR = 12;
    public static final int STATE_NOT_READY = 13;
    public static final int STATE_CUOD_CTA = 15;
    public static final int STATE_INCOMPATIBLE = 250;
    public static final int STATE_RECOVERY = 251;
    public static final int STATE_NOT_AVAILABLE = 252;
    public static final int STATE_INCOMPLETE = 253;
    public static final int STATE_NO_CONNECTION = 254;
    private WPropertyEditor _pe;
    private static Hashtable STATE_MAP = new Hashtable();

    public void updateValue(WPropertyEditor wPropertyEditor) {
        String string = wPropertyEditor.getAsText();
        String string2 = (String)STATE_MAP.get(string);
        if (string2 != null) {
            this.setText(string2);
        } else {
            this.setText("");
        }
    }

    public static String getStateValue(int n) {
        return (String)STATE_MAP.get(String.valueOf(n));
    }

    public static boolean errorState(int n) {
        return n == 12;
    }

    public static boolean readyState(int n) {
        return n == 1;
    }

    public static boolean initializingState(int n) {
        return n == 6;
    }

    public static boolean incompleteState(int n) {
        return n == 253;
    }

    public static boolean incompatibleState(int n) {
        return n == 250;
    }

    public static boolean noPowerState(int n) {
        return n == 3;
    }

    public static boolean noConnectionState(int n) {
        return n == 254;
    }

    public static boolean bootingState(int n) {
        return n == 5;
    }

    public static boolean runningState(int n) {
        return n == 8;
    }

    public static boolean cuodCtaState(int n) {
        return n == 15;
    }

    public static boolean recoveryState(int n) {
        return n == 251;
    }

    public static boolean notAvailableState(int n) {
        return n == 252;
    }

    public static boolean openFirmwareState(int n) {
        return n == 9;
    }

    static {
        STATE_MAP.put("1", HSCResourceBundleUtil.getMessage("CECBundle", "CEC_READY", "Ready"));
        STATE_MAP.put("3", HSCResourceBundleUtil.getMessage("CECBundle", "CEC_NO_POWER", "No Power"));
        STATE_MAP.put("5", HSCResourceBundleUtil.getMessage("LPARBundle", "LPAR_STATE_BOOTING", "Starting"));
        STATE_MAP.put("6", HSCResourceBundleUtil.getMessage("CECBundle", "CEC_INITIALIZING", "Initializing"));
        STATE_MAP.put("8", HSCResourceBundleUtil.getMessage("CECBundle", "CEC_RUNNING", "Running"));
        STATE_MAP.put("9", HSCResourceBundleUtil.getMessage("LPARBundle", "LPAR_STATE_OPEN_FIRMWARE", "Open Firmware"));
        STATE_MAP.put("12", HSCResourceBundleUtil.getMessage("CECBundle", "CEC_ERROR", "Error"));
        STATE_MAP.put("13", HSCResourceBundleUtil.getMessage("LPARBundle", "LPAR_STATE_NOT_READY", "Not Ready"));
        STATE_MAP.put("250", HSCResourceBundleUtil.getMessage("CECBundle", "CEC_INCOMPATIBLE", "Version Mismatch"));
        STATE_MAP.put("251", HSCResourceBundleUtil.getMessage("CECBundle", "CEC_STATE_RECOVERY", "Recovery"));
        STATE_MAP.put("252", HSCResourceBundleUtil.getMessage("LPARBundle", "NOT_AVAILABLE", "Not Available"));
        STATE_MAP.put("253", HSCResourceBundleUtil.getMessage("CECBundle", "CEC_INCOMPLETE", "Incomplete"));
        STATE_MAP.put("254", HSCResourceBundleUtil.getMessage("CECBundle", "CEC_NO_CONNECTION", "No Connection"));
        STATE_MAP.put("15", HSCResourceBundleUtil.getMessage("CECBundle", "CEC_CUOD_CTA", "CUoD Click to Accept"));
    }
}

